using System;
using System.Data;
using System.Data.SqlClient;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/6/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component implementing database read/write functionality
	///	for donation type data.
	///</summary>

		#endregion

	public class DonationType 
	{
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="645"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>DataTable containing the list of donation types</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1176"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves a list of all possible donation type values
		/// </summary>
		/// <returns>DataTable of donation types</returns>
		public static DataTable GetDonationTypeLookupList()
		{
			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetDonationTypeLookupList.StoredProcName );
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1169"> 
		///		<ExpectedInput>Donation type identifier</ExpectedInput>
		///		<ExpectedOutput>The data row containing donation type data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1871"> 
		///		<ExpectedInput>Invalid Id</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets donation type by ID
		/// </summary>
		/// <param name="donationTypeID">Donation type ID</param>
		/// <returns>DataRow containing donation type details</returns>
		public static DataRow GetDonationTypeByID( int donationTypeID )
		{			
			SqlParameter prm = new SqlParameter( STOREDPROC.GetDonationTypeByID.donationtypeid, System.Data.SqlDbType.Int );
			prm.Value = donationTypeID;

			return Common.StoredProcedure.GetSingleDataRow( STOREDPROC.GetDonationTypeByID.StoredProcName, prm );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="646"> 
		///		<ExpectedInput>Donation type code</ExpectedInput>
		///		<ExpectedOutput>The data row containing donation type data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1900"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///		Gets a donation type by its code
		/// </summary>
		/// <param name="donationTypeCode">Donation type code</param>
		/// <returns>DataRow containing a donation type details</returns>
		public static DataRow GetDonationTypeByCode( char donationTypeCode )
		{
			SqlParameter prm = new SqlParameter( STOREDPROC.GetDonationTypeByCode.DonationTypeCode, System.Data.SqlDbType.Char );
			prm.Value = donationTypeCode;

			return Common.StoredProcedure.GetSingleDataRow( STOREDPROC.GetDonationTypeByCode.StoredProcName, prm );
		}
	}

}

